"""
    @package
    BETA LAYOUT Bom for Assembly Ver 2
    Generate a Tab delimited list (csv file type).
    Components are sorted by ref (part) and grouped by value with same footprint
    Command line:
    python "pathToFile/beta_layout_bom.py" "%I" "%O.csv"
"""

# Import the KiCad python helper module and the csv formatter
import csv
import sys
from os import path
import kicad_netlist_reader

# Import the beta stock database
stock_list = []

if path.exists(sys.path[0] + '/Beta_Stock.BOMdb'):
    beta_stock_file = open(sys.path[0] + '/Beta_Stock.BOMdb', 'r')
    beta_stock_lines = beta_stock_file.readlines()
    for line in beta_stock_lines:
        stock_list.append(line)
    beta_stock_file.close()
else:
    print("""INFO: Beta_Stock.BOMdb not found in same directory as beta_layout_bom.py script.
    Continuing without searching for Beta Stock""")

# Generate an instance of a generic netlist, and load the netlist tree from
# the command line option. If the file doesn't exist, execution will stop
net = kicad_netlist_reader.netlist(sys.argv[1])

# Open a file to write to, if the file cannot be opened output to stdout
# instead
try:
    f = open(sys.argv[2], 'w')
except IOError:
    e = "Can't open output file for writing: " + sys.argv[2]
    print(__file__, ":", e, sys.stderr)
    f = sys.stdout

# Create a new csv writer object to use as the output formatter
out = csv.writer(f, lineterminator='\n', delimiter=',',
                 quotechar='\"', quoting=csv.QUOTE_ALL)

# Output a set of rows for a header providing general information
out.writerow(['KiCAD BILL OF MATERIAL WITH BETA STOCK ' + net.getDate()])
out.writerow(['Part', 'Value', 'Device', 'Package', 'Description',
              'Description2', 'Qty', 'Place_YES/NO', 'Provided_by_me_YES/NO',
              'Distributor', 'Ordernumber', 'Remarks'])
# Get all of the components in groups of matching parts + values
# (see ky_generic_netlist_reader.py)
grouped = net.groupComponents()

# Output all of the component information
for group in grouped:
    REFS = ""

    # Add the reference of every component in the group and keep a reference
    # to the component so that the other data can be filled in once per group
    for component in group:
        REFS += component.getRef() + ", "
        c = component

    # Beta Stock
    FILTERED_FOOTPRINT = c.getFootprint()
    FILTERED_VALUE = c.getValue()
    FILTERED_Voltage = c.getField("Voltage")
    FILTERED_Dielectric = c.getField("Dielectric")
    FILTERED_Power = c.getField("Power")

    # Place/Provided
    FILTERED_Place = c.getField("Place")
    FILTERED_Provided = c.getField("Provided")

    # Suppliers
    FILTERED_DigiKey = c.getField("DigiKey")
    FILTERED_Mouser = c.getField("Mouser")
    FILTERED_Farnell = c.getField("Farnell")
    FILTERED_RS = c.getField("RS")

    DESCRIPTION2 = ""
    SUPPLIER = ""
    SKU = ""

    packages = ["0402", "0603", "0805", "1206"]
    for package in packages:
        if "R_" + package + "_" in FILTERED_FOOTPRINT:
            FILTERED_FOOTPRINT = "R" + package
            break
        if "C_" + package + "_" in FILTERED_FOOTPRINT:
            FILTERED_FOOTPRINT = "C" + package
            break

    for line in stock_list:
        arr = line.split("\t")
        if FILTERED_Power == "":
            if "R-EU_" + FILTERED_FOOTPRINT + ":" + FILTERED_VALUE == arr[0]:
                DESCRIPTION2 = arr[5]
                SUPPLIER = "Beta"
                SKU = arr[9]
                break
        else:
            if "R-EU_" + FILTERED_FOOTPRINT + ":" + FILTERED_VALUE == arr[0] and FILTERED_Power in arr[5]:
                DESCRIPTION2 = arr[5]
                SUPPLIER = "Beta"
                SKU = arr[9]
                break
        if FILTERED_Dielectric == "" and FILTERED_Voltage == "":
            if "C-EU" + FILTERED_FOOTPRINT + ":" + FILTERED_VALUE == arr[0]:
                DESCRIPTION2 = arr[5]
                SUPPLIER = "Beta"
                SKU = arr[9]
                break
        elif FILTERED_Dielectric != "" and FILTERED_Voltage != "":
            if "C-EU" + FILTERED_FOOTPRINT + ":" + FILTERED_VALUE == arr[0] and FILTERED_Dielectric in arr[5] and FILTERED_Voltage in arr[5]:
                DESCRIPTION2 = arr[5]
                SUPPLIER = "Beta"
                SKU = arr[9]
                break
        elif FILTERED_Dielectric != "":
            if "C-EU" + FILTERED_FOOTPRINT + ":" + FILTERED_VALUE == arr[0] and FILTERED_Dielectric in arr[5]:
                DESCRIPTION2 = arr[5]
                SUPPLIER = "Beta"
                SKU = arr[9]
                break
        else:
            if "C-EU" + FILTERED_FOOTPRINT + ":" + FILTERED_VALUE == arr[0] and FILTERED_Voltage in arr[5]:
                DESCRIPTION2 = arr[5]
                SUPPLIER = "Beta"
                SKU = arr[9]
                break

    if SUPPLIER == "" and FILTERED_Place == "YES" and FILTERED_Provided == "NO":
        if FILTERED_RS != "":
            SUPPLIER = "RS"
            SKU = FILTERED_RS
        if FILTERED_DigiKey != "":
            SUPPLIER = "DigiKey"
            SKU = FILTERED_DigiKey
        if FILTERED_Mouser != "":
            SUPPLIER = "Mouser"
            SKU = FILTERED_Mouser
        if FILTERED_Farnell != "":
            SUPPLIER = "Farnell"
            SKU = FILTERED_Farnell
    # Fill in the component groups common data
    out.writerow([REFS, c.getValue(), c.getPartName(), c.getFootprint(),
                  c.getDescription(), DESCRIPTION2, len(group), FILTERED_Place, FILTERED_Provided, SUPPLIER, SKU, ""])
